/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>

#include <csl_mbx.h>
#include <soc.h>

#include "metypes.h"

xint
arm_announce(uint16 command, uint16 data)
{
    CSL_MbxHandle hMbxA2D;
    CSL_MbxData mbxData;
    CSL_MbxObj mbxObj;
    CSL_MbxParam mbxParam;

    CSL_Status status;
    xint    flag;
    uint32  arg;

    CSL_mbxInit(NULL);

    hMbxA2D = CSL_mbxOpen(&mbxObj, CSL_MBX_ARM2DSP1, &mbxParam, &status);
    if (status != CSL_SOK)
    {
        printf("Error Opening mainbox(ARM2DSP1) instance !\n");
        exit();
    }

    /* Pend until mailbox is ready for write  */
    while (1)
    {
        if (CSL_SOK != CSL_mbxGetHwStatus(hMbxA2D, CSL_MBX_QUERY_FLAG_STATUS, &flag))
        {
            printf("Error getting the ARM2DSP1 status !\n");
            exit();
        }

        if (!flag)
        {
            break;
        }
    }

    arg = command;
    arg = (arg << 16) + (uint32) data;

    mbxData.dataWidth = CSL_MBX_DATA_32BIT;
    mbxData.data = arg;

    status = CSL_mbxHwControl(hMbxA2D, CSL_MBX_CMD_WRITE_DATAREGS, &mbxData);
    if (CSL_SOK != status)
    {
        printf("arm announce error !\n");
        exit();
    }

    CSL_mbxClose(hMbxA2D);

    return 0;
}
